'Convert a font from a graphics format file to a DefineFont hexadecimal format in a new file
'Learned arrays, OPEN FOR INPUT, OPEN FOR OUTPUT, INPUT#, HEX$, MID$, CHR$, PRINT#,
'        CLOSE#, Graphic font design, DefineFont syntax, 32-bit words, hexadecimals
dim a, b, i, j, k, w, h, sc, ec 'width, height, start chr$ value, end chr$ value
dim string LI$(96)
dim integer LC(96) 
dim string NumChars$, StartChar$, Height$, Width$
cls
mode 1, 8
'option legacy on
'font load "font 08.fnt" as #8
'load font "font 08.fnt"
'Note: Color Maximite 2 does NOT support graphics format font files.
'      This is a 6x4 pixel font
'      What does the 60200604 mean?
'      60 = 16 * 6 + 0 = 96, There will be 96 characters in this font
'      20 = 16 * 2 + 0 = 32, Start with chr$(32)
'      06 = 16 * 0 + 6 =  6, This is the font height for each character
'      04 = 16 * 0 + 4 =  4, This is the font width for each character
' We have 8 * 9 = 72 words. There are 32 bits per word
' 72 x 32 = 2,304 bits
' 6 x 4 = 24 bits per font character, 24 x 96 = 2,304 bits

'      DefineFont #8
'       60200604
'       44000000 00A04040 0AAEAE00 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx 
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'       xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
'      End DefineFont 

'8,12,32,39 in input file, so we have FF818989 89898989 898981FF
'oooooooo  = 11111111 = 255 = FF   
'o      o  = 10000001 = 129 = 81
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o   o  o  = 10001001 = 137 = 89
'o      o  = 10000001 = 129 = 81
'oooooooo  = 11111111 = 255 = FF

open "font 08.fnt" for input as #1  
open "define font.fnt" for output as #2
input #1, w, h, sc, ec
for a = 1 to (ec - sc + 1) * h 
  line input #1, LI$(a)
next a
NumChars$ = hex$(ec - sc + 1, 2) : StartChar$ = hex$(sc, 2)
Height$ = hex$(h, 2) : Width$ = hex$(w, 2)
for a = 1 to (ec - sc + 1) * h
  for b = 1 to 8 'eight characters per line in this font input file
    if mid$(LI$(a), b, 1) = chr$(32) then 'space character, then the bit is OFF
      LC(a) = LC(a) + 0
    else 'not a space character, then the bit is ON
      if b = 1 then LC(a) = LC(a) + 128
      if b = 2 then LC(a) = LC(a) +  64
      if b = 3 then LC(a) = LC(a) +  32
      if b = 4 then LC(a) = LC(a) +  16
      if b = 5 then LC(a) = LC(a) +   8
      if b = 6 then LC(a) = LC(a) +   4
      if b = 7 then LC(a) = LC(a) +   2
      if b = 8 then LC(a) = LC(a) +   1
    endif
  next b
next a
print #2, "DefineFont #8"
print #2, " "; NumChars$; StartChar$; Height$; Width$
a = 1
for i = 1 to 3 'Later make the 3 a calculated variable
  print #2, " ";
  for j = 1 to 8 'eight words per line in the output font file
    for k = 1 to 4 'four hexadecimal number pairs per word      
      if k = 1 then
        print #2, hex$(LC(a + 3), 2); 
      elseif k = 2 then 
        print #2, hex$(LC(a + 2), 2);
      elseif k = 3 then
        print #2, hex$(LC(a + 1), 2);
      elseif k = 4 then
        print #2, hex$(LC(a), 2);
      endif
    next k
    a = a + 4
    print #2, " ";
  next j
  print #2, ""
next i
print #2, "End DefineFont"

'?"DefineFont #8"
'?" "; NumChars$; StartChar$; Height$; Width$
'a = 1
'for i = 1 to 3 'Later make the 3 a calculated variable
'  ?" ";
'  for j = 1 to 8 'eight words per line in the output font file
'    for k = 1 to 4 'four hexadecimal number pairs per word      
'      ? hex$(LC(a), 2); 'Make 255 a variable 
'      a = a + 1
'    next k
'    ?" ";
'  next j
'  ?""
'next i
'?"End DefineFont"

close #1
close #2



